Серверная часть
# 1 Задача серверной части принимать HTTP-POST-запросы и отвечать на них. 

В процессе работы необходимо взаимодействовать с СУБД PostgreSQL. СУБД может находиться физически на другой  машине.
 
## 1.1 База данных хранит информацию принятую от клиентов. 

Информация имеет текстовый и бинарный формат, вместе с этой информацией хранится информация о клиенте, который прислал данные.

Каждый принятыый блок информации должен сождержать следующие данные:
* время
* Id клиента (пункт 2.1.2)
* Тег группы  (пункт 2.1.1)
* данные из тела POST (пункт 3)

# 2 Данные на сервер отправляются через HTTP POST-запросы.  

Между сервером и клиентом может стоять сколько угодно reverse-proxy, load-balancer и  DNAT. Таким образом, нет никакого способа узнать ip-адрес клиента.

## 2.1 Каждый запрос содержит в URI три компонента разделённых символом "/" - тег группы, id клиента .  

Каждый POST имеет URI следующего формата:

/<group-tag>/<clientid>/60/

, где group-tag - тег группы,  clientid - id клиента. 

### 2.1.1 Тег группы - это произвольная строка состоящая из символов (a-z) и цифр (0-9). Параметр не чувствителен к регистру.

### 2.1.2 Id клиента - это строка состоящая из двух компонентов разделённых точкой. 

Первая часть имеет формат <name>_XYYYYYYY, 
где 
  name это некоторое имя которое может как-то  идентифицировать машину (имя компьюетра или имя пользователя, в зависимости от типа операционной системы), 
  X - символ обозначающий тип системы на которой работает клиент (W -  windows, L - linux, A - андроид, M - Mac OS), 
  YYYYYYY - 3-7 цифр содержащих major-version, minor-version и build операционной системы если таковые имеются у системы (например,  длЯ 6.1 build 7600 это будет 617600). 

Вторая часть содержит 32 случайных символов 0-9, A-F. 
Пример id клиента - QWERTY_W617600.11223344556677889900AABBCCDDEEFF. 

Параметр не  чувствителен к регистру.

##2.2 Каждый ответ сервера может быть со следующими HTTP-кодами: 
  200 и 403. 
  
  Ответ 200 всегда имеет тело с содержание "/1/" (content-type: text/plain), 
  а ответ 403 используется если прислан не POST-запрос, 
    тело POST имеет неизвестный формат или поля, 
    URI неизвестного формата, 
    или clientid неправильного формата.

# 3 POST-запрос по коду /60/ имеет тело в формате multipart/form-data. 

И имеет следущие поля:

## 3.1 "data" - бинарные данные, размером до 32 КБ, если больше 32 КБ, то лишнее должно быть обрезано без генерации ошибок

## 3.2 "keys" - UTF-8 строка. Максимальная длина 1024 символа. Если более лимита, то лишнее должно быть обрезано без геренации ошибок.

## 3.3 "link" - UTF-8 строка. Максимальная длина 4096 символов. Если более лимита, то лишнее должно быть обрезано без геренации ошибок

## 3.4 "image" - бинарные данные, размером до 100 КБ. Если больше 100 КБ, то данные не должны сохраняться в базу. Поле опциональное, если его нет, то это нормально.

## 3.5 В СУБД в таблице ни один из столбцов из пукнтов 3.1-3.4 не должен быть индексирован

# 4 POST-запросы по кодам /81/ и /82/ имеют тело в формате multipart/form-data. 

И имеют следущие поля:

## 4.1 "data" - бинарные данные, размером до 8 МБ, если больше 8 МБ, то лишнее должно быть обрезано без генерации ошибок

## 4.2 "source" - UTF-8 строка. Максимальная длина 1024 символа. Если более лимита, то лишнее должно быть обрезано без геренации ошибок.

## 4.3 данные полученные по кодам 81 и 82 должны храниться в одной таблице, но в отдельно от данных полученных по коду 60. Должен быть индексированный столбец с указанием кода запроса, через который были получены данные. Столбцы с данными data и source не должны индексироваться.

# 5 POST-запросы по коду /90/ имеет тело в формате multipart/form-data.

И имеют следущие поля:

## 5.1 proclist

## 5.2 sysinfo

# 6 В конфиге серверного приложения должны задаваться:

* порт для HTTP-коннектов и данные для СУБД, 
* лимиты размеров полей из пунктов 3.1-3.4. 


класс online -  счетчик индивидуальный
класс age - глобальный, время отсчитывается от времени указанном в столбце created_at
класс geo - счетчик не нужен
класс devhash_dup - счетчик не нужен
класс command_complete - счетчик индивидуальный
